*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file for Nids Wave 2

* THIS IS 2nd WEALTH DO FILE - MERGING DATASETS TOGETHER: 2 OF 6
* THIS DO FILE MERGES TOGETHER THE DATASETS REQUIRED FOR CREATING THE WEALTH VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master wealth do file (1 of 6)"

version 12.0

*=====================================================================================================================================

* OPENING THE PROXY, CHILD AND ADULT, ADJUSTING WHERE NESSESARY AND APPENING THE 3 DATASETS

*PROXY
use "$DataIN\Proxy_$VersionIN.dta", clear
cap renpfix w2_p_
rename emactcur_u prox_emp
forvalues x=1/5 {
	rename em1inc_brac`x' prox_em1inc_s`x'
	}
sort pid
gen proxy=1
save "$DataOUT\proxy_append.dta", replace

*CHILD
use "$DataIN\Child_$VersionIN.dta", clear
cap renpfix w2_c_
sort pid
gen proxy=0
save "$DataOUT\child_append.dta", replace

*ADULT
use "$DataIN\Adult_$VersionIN.dta", clear
cap renpfix w2_a_
sort pid
gen proxy=0

*APPENDING

append using "$DataOUT\child_append.dta"
append using "$DataOUT\proxy_append.dta"

label variable proxy "Data from proxy survey"
label define dummy 0 "No" 1 "Yes"
label values proxy dummy

sort w2_hhid
save "$DataOUT\acp.dta", replace

*Now bringing in the HH Questionnaire dataset, after doing some cleaning.

use "$DataIN\HHQuestionnaire_$VersionIN.dta", clear

cap renpfix w2_h_

*Dropping all HH dead
drop if outcome==6

*HH month of interview
gen temp=.
replace temp=intrv_m if intrv_y==2010
replace temp=intrv_m+12 if intrv_y==2011
replace temp=25 if temp==.
rename temp hhintmonth

*HH-level (one-shot) income
recode tinc (min/-3=.), gen(hhq_inc)
label variable hhq_inc "HH (one shot) income from HH questionnaire"

*Sorting out the one-shot income brackets
gen temp=.
replace temp=350 if tinc_brac4==3
replace temp=700 if tinc_brac4==2
replace temp=1000 if tinc_brac4==1 & tinc_brac2==3
replace temp=1300 if tinc_brac2==2
replace temp=1800 if tinc_brac2==1 & tinc_brac1==3
replace temp=2300 if tinc_brac1==2
replace temp=3500 if tinc_brac1==1 & tinc_brac3==3
replace temp=4700 if tinc_brac3==2
replace temp=7850 if tinc_brac3==1 & tinc_brac5==3
replace temp=11000 if tinc_brac5==2
replace temp=22000 if tinc_brac5==1
gen hhq_inc_ib=temp
gen hhq_incb=hhq_inc
replace hhq_incb=hhq_inc_ib if hhq_inc_ib!=. & hhq_incb==.
label variable hhq_incb "HH income from HH questionnaire incl brackets and (logical) imps"
drop temp


**********************************************************
*Sorting out the one-shot net worth stuff
gen hhq_networth=.
replace hhq_networth=0 if ownsellft==2

*Something left over

recode ownsellft_v (min/0=.)
gen temp=.
replace temp=12500 if ownamtlft_brac4==3
replace temp=25000 if ownamtlft_brac4==2
replace temp=62500 if ownamtlft_brac4==1 & ownamtlft_brac2==3
replace temp=100000 if ownamtlft_brac2==2
replace temp=300000 if ownamtlft_brac2==1 & ownamtlft_brac1==3
replace temp=500000 if ownamtlft_brac1==2
replace temp=750000 if ownamtlft_brac1==1 & ownamtlft_brac3==3
replace temp=1000000 if ownamtlft_brac3==2
replace temp=3000000 if ownamtlft_brac3==1 & ownamtlft_brac5==3
replace temp=5000000 if ownamtlft_brac5==2
replace temp=10000000 if ownamtlft_brac5==1
replace hhq_networth=temp if hhq_networth==.
replace hhq_networth=ownsellft_v if hhq_networth==.
drop temp

*Debt
recode ownseldbt_v (min/0=.)
gen temp=.
replace temp=-5000 if owndebt_brac4==3
replace temp=-10000 if owndebt_brac4==2
replace temp=-17500 if owndebt_brac4==1 & owndebt_brac2==3
replace temp=-25000 if owndebt_brac2==2
replace temp=-37500 if owndebt_brac2==1 & owndebt_brac1==3
replace temp=-50000 if owndebt_brac1==2
replace temp=-75000 if owndebt_brac1==1 & owndebt_brac3==3
replace temp=-100000 if owndebt_brac3==2
replace temp=-300000 if owndebt_brac3==1 & owndebt_brac5==3
replace temp=-500000 if owndebt_brac5==2
replace temp=-1000000 if owndebt_brac5==1
replace hhq_networth=temp if hhq_networth==.
replace hhq_networth=ownseldbt_v if hhq_networth==.
drop temp


**********************************************************


*Housing status
gen homestatus=.
replace homestatus=1 if rnt==1 & ownd==2
replace homestatus=2 if ownpaid==2 & ownd==1
replace homestatus=3 if ownpaid==1 & ownd==1
replace homestatus=4 if rnt==2 & ownd==2
replace homestatus=5 if homestatus==.
label define homestatus 1 "Renting" 2 "Homeowners with mortgage" 3 "Homeowners no mortgage" ///
4 "Don't own or rent" 5 "Missing"
label values homestatus homestatus
gen mortgage=1 if homestatus==2
replace mortgage=0 if homestatus!=2 & homestatus!=.

*Housing rent
recode rntpay (min/0=.), gen(rentpay)

*Dwelling characteristics
recode dwltyp (-9/-3=.) (1=1 "Dwelling/house or brick structure") (2=2 "Traditional dwelling/hut/structure") ///
(3=3 "Flat or apartment") (4=4 "Town/cluster/semi-detached house") (5=3) (6=6 "Dwelling/house/flat/room in backyard") ///
(7=7 "Informal dwelling/shack in backyard") (8=8 "Informal dwelling/shack not in backyard") (9=9 "Room/flatlet") ///
(10=11) (11=11 "Other"), gen(hometype)
label variable hometype "Type of dwelling"
gen hometype_d=hometype!=.
replace hometype=0 if hometype==.
lab def hometype 0 "Missing", add
recode dwlrms (-9/-3=.) (35/max=.), gen(homerooms) 
label variable homerooms "Number of rooms in dwelling unit"
gen homerooms_d=homerooms!=.
replace homerooms=0 if homerooms==.
gen homeroomssq=homerooms^2
recode dwlmatroof (-9/-3=.) (1=1 "Bricks or cement") (2=1) (3=3 "Corrugated iron/zinc") (4/8=7 "Other") ///
(9=4 "Tile") (10=7 "Other") (11=5 "Thatching") (12=6 "Asbestos/cement roof sheeting") (13=7), gen(homeroof)
label variable homeroof "Dwelling unit's roofing material"
gen homeroof_d=homeroof!=.
replace homeroof=0 if homeroof==.
lab def homeroof 0 "Missing", add
recode dwlmatrwll (-9/-3=.) (1=1 "Bricks") (2=2 "Cement block/concrete") (3=3 "Corrugated iron/zinc") ///
(7=4 "Mixture of mud and cement") (10=5 "Mud bricks") (4/6=6 "Other") (8/9=6) (11/13=6), gen(homewalls)
label variable homeroof "Dwelling unit's walling material"
gen homewalls_d=homewalls!=.
replace homewalls=0 if homewalls==.
lab def homewalls 0 "Missing", add

*Rent and owndership variables for imputed rental income stuff
gen ownhome=ownd==1
lab var ownhome "Household member owns home"
gen ownfullypaid=ownpaid==1
lab var ownfullypaid "Property is fully paid off"

gen ownotherhome=ownoth==1
lab var ownotherhome "Hosehold member owns other property"
gen ownotherfullypaid=ownothpaid==1
lab var ownotherfullypaid "Other properties are fully paid off"


recode ownowd (min/0=.), gen(bondowing)
lab var bondowing "Amount of bond still outstanding"
gen lnbondowing=ln(bondowing)
gen bondowing_d=bondowing!=.
recode mrkv (min/0=.), gen(propvalue)
lab var propvalue "Property's market value"
gen lnpropvalue=ln(propvalue)
gen propvalue_d=propvalue!=.

*Value of other properties and bonds owing on them

recode mrkvoth (min/0=.), gen (otherpropvalue)
lab var otherpropvalue "Other properties' market value"
gen lnotherpropvalue=ln(otherpropvalue)
gen otherpropvalue_d=otherpropvalue!=.

recode ownowdtot (min/0=.), gen(otherbondowing)
lab var otherbondowing "Other properties bond outstanding"
gen lnotherbondowing=ln(otherbondowing)
gen otherbondowing_d=otherbondowing!=.

gen hrcorr=homeroof==3

*Imputed rental income
gen rent_would_rec=1
replace rent_would_rec=0 if homestatus==1
replace rent_would_rec=. if homestatus==5

recode rntpot (min/0=.) (50000/max=.), gen(rent_would)
replace rent_would=. if homestatus==5

gen rent_would_d=rent_would!=.

gen hhresponse=outcome==1

keep w2_hhid hometype homerooms homeroomssq homeroof homewalls hometype_d homerooms_d homeroof_d homewalls_d ///
hhq_inc hhq_inc_ib hhq_incb tinc_brac* tinc rntpot rentpay homestatus mortgage ///
ownhome ownfullypaid bondowing propvalue lnbondowing lnpropvalue bondowing_d propvalue_d ///
rent_would_rec rent_would rent_would_d hhintmonth ownotherhome ownotherfullypaid ownotherfullypaid ///
otherpropvalue lnotherpropvalue otherpropvalue_d otherbondowing lnotherbondowing otherbondowing_d hhresponse ///
aglscat aglscatsel aglsshp aglsshpsel aglsgt aglsgtsel aglspig aglspigsel ///
aglshrs aglshrssel aglsdnk aglsdnksel aglschc aglschcsel hhq_networth
sort w2_hhid
save "$DataOUT\hhquestionmerge.dta", replace

use "$DataOUT\acp.dta", clear
merge m:1 w2_hhid using "$DataOUT\hhquestionmerge.dta"
drop _merge

save "$DataOUT\acphhq.dta", replace

*Bringing in the Household Roster Dataset.

use "$DataIN\HouseholdRoster_$VersionIN.dta", clear
cap renpfix w2_r_
cap drop age 
cap drop gen
merge 1:1 pid w2_hhid using "$DataIN\indderived_$VersionIN.dta", keepusing(w2_best_age* w2_best_gen)
cap rename w2_hhid

*Dropping all the non-resident members, and all dead respondents
drop if pres==2
drop if dead==1

*HH size and children in the HH
gen temp=1 if pid!=.
replace temp=0 if mem==2 | mem==999
egen hhsizer=count(temp), by(w2_hhid) 
label variable hhsizer "Number of household residents"
drop temp

gen resmem=1

*Resident children in the HH
gen ageunder15=w2_best_age_yrs<15 if resmem==1 & w2_best_age_yrs>=0
gen ageunder18=w2_best_age_yrs<18 if resmem==1 & w2_best_age_yrs>=0
egen hhchildren=sum(ageunder15), by(w2_hhid)
egen hhchildren18=sum(ageunder18), by(w2_hhid)
label variable hhchildren "Number of household children<15"
label variable hhchildren18 "Number of household children<18"
drop ageunder15
drop ageunder18

recode w2_best_gen (2=0) (3/24=.), gen(roster_male)

keep pid w2_hhid marstt hhsizer hhchildren hhchildren18 roster_male mem w2_best_age_yrs

recode marstt (-9/-3=.) (1/2=1) (3/5=0), gen(roster_married)
gen roster_married_d=roster_married!=.
replace roster_married=0 if roster_married==.
rename marstt roster_mstatus
label variable roster_married "Married or living with partner"
drop if mem==2 | mem==999
drop mem
sort pid

save "$DataOUT\newhhr.dta", replace

use "$DataOUT\acphhq.dta", clear

merge 1:m pid w2_hhid using "$DataOUT\newhhr.dta"
drop if _merge!=3
drop _merge
save "$DataOUT\temp.dta", replace

*Bringing in individual derived variables

use "$DataIN\indderived_$VersionIN.dta", clear
cap renpfix w2_
rename hhid w2_hhid
keep w2_hhid pid best_race best_gen best_edu
save "$DataOUT\temp2.dta", replace

use "$DataOUT\temp.dta", clear
merge 1:1 pid using "$DataOUT\temp2.dta"
drop _merge
save "$DataOUT\temp3.dta", replace

*Bringing in the household derived variables

use "$DataIN\hhderived_$VersionIN.dta", clear
cap renpfix w2_
rename hhid w2_hhid

rename prov2011 province
replace province=11 if province==.
lab def province 11 "Missing"

replace geo2011=5 if geo2011==.
lab def w2_hhgeo 5 "MISSING", add

keep w2_hhid province geo2011
save "$DataOUT\temp4.dta", replace

use "$DataOUT\temp3.dta", clear
merge m:1 w2_hhid using "$DataOUT\temp4.dta"
drop if _merge==2 /*This drops the all HH dead observations.*/
drop _merge
save "$DataOUT\temp5.dta", replace

*Bringing in the Link File

use "$DataIN\Link_File_$VersionIN.dta", clear
duplicates drop pid, force
save "$DataOUT\temp6.dta", replace

use "$DataOUT\temp5.dta", clear
merge 1:1 pid using "$DataOUT\temp6.dta"
drop if _merge!=3
drop _merge

*Drop all out individuals in HHNR households
drop if outcome==3

save "$DataOUT\data.dta", replace

erase "$DataOUT\child_append.dta"
erase "$DataOUT\proxy_append.dta"
erase "$DataOUT\acphhq.dta"
erase "$DataOUT\newhhr.dta"
erase "$DataOUT\temp.dta"
forvalues q=2/6 {
erase "$DataOUT\temp`q'.dta"
}
erase "$DataOUT\acp.dta"
erase "$DataOUT\hhquestionmerge.dta"

* end of do file
*===================================================================================================================================
